<?php

namespace app\models\form;

use Yii;
use yii\base\Model;
use yii\db\ActiveRecord;
use app\models\User;


class SaveUser extends Model
{
    public $username;
    public $password;
    public $secret_word;


   
    public function rules()
    {
        return [
            
            [['username', 'password','secret_word'], 'required', 'message' => 'Необходимо заполнить это поле'],
            ['username', 'unique', 'targetClass' => User::className(),  'message' => 'Игрок с этим логином уже зарегистрирован'],
            ['password', 'string', 'length' => [5, 40]],
            ['username', 'string', 'length' => [3, 20]],
			['username', 'match', 'pattern' => '/^(?>\pL+ ?\b)+$/u'],
			['secret_word', 'string', 'length' => [3, 15]],
        ];
    }
    
    
    public function attributeLabels()
	 {
		 
		 return 
		 [
		  'secret_word' => 'Секретное слово',
		  'password' => 'Пароль',
		  'username' => 'Ник',
		  
		 ];
		 
	 }
 
}
